<?php

/**
 * 侧边栏组件、页面模块
 */
defined('EMLOG_ROOT') || exit('access denied!');
?>

<?php
/**
 * 页顶：导航
 */
function blog_navi()
{
    global $CACHE;
    $navi_cache = $CACHE->readCache('navi');
?>
    <nav>
        <ul class="nav-items">
            <?php
            foreach ($navi_cache as $value):
                if ($value['pid'] != 0)
                    continue;
                if ($value['url'] == 'admin' && (!User::isVisitor())):
            ?>
                    <li class="item"><a href="<?= BLOG_URL ?>admin/" class="nav-link">管理</a></li>
                    <li class="item"><a href="<?= BLOG_URL ?>admin/account.php?action=logout" class="nav-link">退出</a></li>
                <?php
                    continue;
                endif;
                $newtab = $value['newtab'] == 'y' ? 'target="_blank"' : '';
                $value['url'] = $value['isdefault'] == 'y' ? BLOG_URL . $value['url'] : trim($value['url'], '/');
                $current_tab = BLOG_URL . trim(Dispatcher::setPath(), '/') == $value['url'] ? 'active' : '';
                ?>
                <?php if (!empty($value['children']) || !empty($value['childnavi'])) : ?>
                    <li class="item">
                        <?php if (!empty($value['children'])): ?>
                            <a href="<?= $value['url'] ?>" <?= $newtab ?>><?= $value['naviname'] ?><i class="icon-simply icon-down ml-5"></i></a>
                            <div class="nav-child-box">
                                <ul class="nav-child-items">
                                    <?php foreach ($value['children'] as $row): ?>
                                        <li class="item"><a href="<?= Url::sort($row['sid']) ?>"><?= $row['sortname'] ?></a></li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        <?php if (!empty($value['childnavi'])) : ?>
                            <a href="<?= $value['url'] ?>" <?= $newtab ?>><?= $value['naviname'] ?><i class="icon-simply icon-down ml-5"></i></a>
                            <div class="nav-child-box">
                                <ul class="nav-child-items">
                                    <?php foreach ($value['childnavi'] as $row): ?>
                                        <?php $newtab = $row['newtab'] == 'y' ? ' target="_blank"' : ''; ?>
                                        <li class="item"><a href="<?= $row['url'] ?>" <?= $newtab ?>><?= $row['naviname'] ?></a></li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                    </li>
                <?php else: ?>
                    <li class="item"><a href="<?= $value['url'] ?>" <?= $newtab ?>><?= $value['naviname'] ?></a></li>
                <?php endif; ?>
            <?php endforeach; ?>
        </ul>
    </nav>
<?php } ?>

<?php
/**
 * 侧边栏：链接
 */
function widget_link($title)
{
    global $CACHE;
    $link_cache = $CACHE->readCache('link');
?>
    <div class="box modularity aside-interlinkage">
        <div class="modul-head">
            <div class="modul-title">
                <i class="icon-simply icon-link mr-5"></i><?= $title ?>
            </div>
            <div class="colorful-dot"></div>
        </div>
        <div class="modul-body">
            <ul class="flex-list flex-warp aside-interlinkage-list">
                <?php foreach ($link_cache as $value): ?>
                    <li class="item"><a href="<?= $value['url'] ?>" title="<?= $value['des'] ?>" target="_blank"><?= $value['link'] ?></a></li>
                <?php endforeach; ?>
            </ul>
        </div>
    </div>
<?php } ?>

<?php
/**
 * 侧边栏：个人资料
 */
function widget_blogger($title)
{
    global $CACHE;
    $user_cache = $CACHE->readCache('user');
    $blogger_aggregates = blogger_aggregates();
    $name = $user_cache[1]['name'];
    $data_platform = studio_string_to_array('simply_aside_blogger_platform', 0, 5);
    $avatar = BLOG_URL . "admin/views/images/avatar.svg";
    $userModel = new User_Model();
    $uid = UID ?: 1;
    $description = '';
    $user = $userModel->getOneUser($uid);
    if ($user) {
        $name = $user['nickname'];
        $description = $user['description'];
        $avatar = User::getAvatar($user['photo']);
    }
?>
    <div class="box aside-blogger">
        <div class="blogger-image">
            <img src="<?= _g('simply_aside_blogger_image') ?>" alt="<?= $name ?>" />
        </div>
        <div class="user-info">
            <div class="avatar">
                <img src="<?= $avatar ?>" alt="<?= $name ?>" />
            </div>
            <div class="user-meta">
                <div class="nickname"><?= $name ?></div>
                <div class="other"><?= $description ?></div>
            </div>
        </div>
        <?php if (!User::isWriter()): ?>
            <?php if (!empty($data_platform)): ?>
                <ul class="flex-list blogger-platform">
                    <?php foreach ($data_platform as $item): ?>
                        <li class="item">
                            <a href="<?= $item[2] ?>" style="background-color: <?= $item[1] ?>;"><?= $item[0] ?></a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            <?php endif; ?>
        <?php endif; ?>
        <?php if (User::isFounder()): ?>
            <ul class="flex-list blogger-statistic">
                <?php foreach ($blogger_aggregates as $key => $item): ?>
                    <li class="item">
                        <div class="name"><?= $key ?></div>
                        <div class="value"><?= $item ?></div>
                    </li>
                <?php endforeach; ?>
            </ul>
        <?php endif; ?>
    </div>
<?php } ?>

<?php
/**
 * 侧边栏：日历
 */
function widget_calendar($title)
{ ?>
    <div class="box modularity aside-calendar">
        <div class="modul-head">
            <div class="modul-title">
                <i class="icon-simply icon-calendar mr-5"></i><?= $title ?>
            </div>
            <div class="colorful-dot"></div>
        </div>
        <div class="modul-body">
            <script>
                function sendinfo(url) {
                    $('.aside-calendar .modul-body').load(url);
                }

                document.addEventListener("DOMContentLoaded", () => {
                    sendinfo('<?= Calendar::url() ?>');
                })
            </script>
        </div>
    </div>
<?php } ?>

<?php
/**
 * 侧边栏：标签
 */
function widget_tag($title)
{
    global $CACHE;
    $tag_cache = array_slice($CACHE->readCache('tags'), 0, 30);
?>
    <div class="box modularity aside-tag">
        <div class="modul-head">
            <div class="modul-title">
                <i class="icon-simply icon-tag mr-5"></i><?= $title ?>
            </div>
            <div class="colorful-dot"></div>
        </div>
        <div class="modul-body">
            <ul class="aside-tag-list">
                <?php foreach ($tag_cache as $value): ?>
                    <li class="item">
                        <a href="<?= Url::tag($value['tagurl']) ?>" title="<?= $value['tagname'] ?>">
                            <div class="title"><?= $value['tagname'] ?></div>
                            <span class="badge"><?= $value['usenum'] ?></span>
                        </a>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>
    </div>
<?php } ?>

<?php
/**
 * 侧边栏：分类
 */
function widget_sort($title)
{
    global $CACHE;
    $sort_cache = $CACHE->readCache('sort') ?>
    <div class="box modularity aside-category">
        <div class="modul-head">
            <div class="modul-title">
                <i class="icon-simply icon-category mr-5"></i><?= $title ?>
            </div>
            <div class="colorful-dot"></div>
        </div>
        <div class="modul-body">
            <ul class="aside-category-list">
                <?php
                foreach ($sort_cache as $value):
                    if ($value['pid'] != 0)
                        continue;
                ?>
                    <li class="item">
                        <a href="<?= Url::sort($value['sid']) ?>" title="<?= $value["description"] ?>">
                            <div class="title"><?= $value['sortname'] ?></div>
                            <span class="badge"><?= $value['lognum'] ?></span>
                        </a>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>
    </div>
<?php } ?>

<?php
/**
 * 侧边栏：最新评论
 */
function widget_newcomm($title)
{
    global $CACHE;
    $com_cache = $CACHE->readCache('comment');
?>
    <div class="box modularity aside-comment">
        <div class="modul-head">
            <div class="modul-title">
                <i class="icon-simply icon-message mr-5"></i><?= $title ?>
            </div>
            <div class="colorful-dot"></div>
        </div>
        <div class="modul-body">
            <ul class="aside-message-list">
                <?php
                foreach ($com_cache as $value):
                    $url = Url::comment($value['gid'], $value['page'], 'comment-' . $value['cid']);
                    $avatar = getEmUserAvatar($value['uid'], $value['mail']);
                ?>
                    <li class="item">
                        <div class="user-info">
                            <div class="avatar">
                                <img src="<?= $avatar ?>" alt="<?= $value['name'] ?>">
                            </div>
                            <div class="user-meta">
                                <div class="nickname"><?= $value['name'] ?></div>
                            </div>
                        </div>
                        <div class="ago"><?= time_ago($value['date']) ?></div>
                        <a class="message" href="<?= $url ?>"><?= $value['content'] ?></a>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>
    </div>
<?php } ?>

<?php
/**
 * 侧边栏：最新微语
 */
function widget_twitter($title)
{
    global $CACHE;
    $index_newtwnum = Option::get('index_newtwnum') ?: 10;
    $Twitter_Model = new Twitter_Model();
    $ts = $Twitter_Model->getTwitters('', 1, $index_newtwnum);
    $user_cache = $CACHE->readCache('user');
?>
    <div class="box modularity aside-comment">
        <div class="modul-head">
            <div class="modul-title">
                <i class="icon-simply icon-message mr-5"></i><?= $title ?>
            </div>
            <div class="colorful-dot"></div>
        </div>
        <div class="modul-body">
            <ul class="aside-message-list">
                <?php foreach ($ts as $value):
                    $author = $user_cache[$value['author']]['name'];
                    $avatar = $user_cache[$value['author']]['avatar'];
                ?>
                    <li class="item">
                        <div class="user-info">
                            <div class="avatar">
                                <img src="<?= $avatar ?>" alt="<?= $author ?>">
                            </div>
                            <div class="user-meta">
                                <div class="nickname"><?= $author ?></div>
                            </div>
                        </div>
                        <div class="ago"><?= $value['date'] ?></div>
                        <span class="message"><?= $value['t']; ?></span>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>
    </div>
<?php } ?>

<?php
/**
 * 侧边栏：最新文章
 */
function widget_newlog($title)
{
    global $CACHE;
    $newLogs_cache = $CACHE->readCache('newlog');
?>
    <div class="box modularity aside-new">
        <div class="modul-head">
            <div class="modul-title">
                <i class="icon-simply icon-new mr-5"></i><?= $title ?>
            </div>
            <div class="colorful-dot"></div>
        </div>
        <div class="modul-body">
            <ul class="aside-new-list">
                <?php foreach ($newLogs_cache as $value): ?>
                    <li class="item">
                        <a href="<?= Url::log($value['gid']) ?>">
                            <div class="title"><?= $value['title'] ?></div>
                            <div class="ago value"><?= time_ago($value['date']) ?></div>
                        </a>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>
    </div>
<?php } ?>

<?php
/**
 * 侧边栏：热门文章
 */
function widget_hotlog($title)
{
    $index_number = 1;
    $index_hotlognum = Option::get('index_hotlognum');
    $Log_Model = new Log_Model();
    $hotLogs = $Log_Model->getHotLog($index_hotlognum);
    $hotLogs = array_slice($hotLogs, 0, 4);
?>
    <div class="box modularity aside-hot">
        <div class="modul-head">
            <div class="modul-title">
                <i class="icon-simply icon-hot mr-5"></i><?= $title ?>
            </div>
            <div class="colorful-dot"></div>
        </div>
        <div class="modul-body">
            <ul class="aside-hot-list">
                <?php
                foreach ($hotLogs as $value):
                    $data_log = get_data_log($value['gid']);
                    $data_log['cover'] = $data_log['cover'] ?: _g('simply_global_thumb');
                ?>
                    <li class="item">
                        <a class="percent-image" href="<?= Url::log($value['gid']) ?>">
                            <figure class="figure">
                                <div class="number"><?= $index_number ?></div>
                                <img src="<?= $data_log['cover'] ?>" alt="<?= $value['title'] ?>" />
                                <figcaption class="figcaption display-unset">
                                    <div class="title"><?= $value['title'] ?></div>
                                    <div class="infos mt-5">
                                        <span class="view mr-10"><?= $data_log['views'] ?>阅读</span>
                                        <span class="date"><?= date('Y/n/j', $data_log['date']) ?></span>
                                    </div>
                                </figcaption>
                            </figure>
                        </a>
                    </li>
                <?php
                    $index_number++;
                endforeach;
                ?>
            </ul>
        </div>
    </div>
<?php } ?>

<?php
/**
 * 侧边栏：搜索
 */
function widget_search($title)
{
?>
    <div class="box modularity aside-search">
        <div class="modul-head">
            <div class="modul-title">
                <i class="icon-simply icon-search mr-5"></i><?= $title ?>
            </div>
            <div class="colorful-dot"></div>
        </div>
        <div class="modul-body">
            <form name="aside-search-form" method="get" action="<?= BLOG_URL ?>index.php">
                <input name="keyword" class="search-input" autocomplete="off" aria-label="Search" type="text">
                <button type="submit" class="search-submit">搜索</button>
            </form>
        </div>
    </div>
<?php } ?>

<?php
/**
 * 侧边栏：归档
 */
function widget_archive($title)
{
    $bar_id = "36";
    global $CACHE;
    $record_cache = $CACHE->readCache('record');
?>
    <div class="box modularity aside-archive">
        <div class="modul-head">
            <div class="modul-title">
                <i class="icon-simply icon-archive mr-5"></i><?= $title ?>
            </div>
            <div class="colorful-dot"></div>
        </div>
        <div class="modul-body">
            <div class="virtual-select">
                <div class="action">
                    <div class="value">请选择</div>
                    <i class="icon-simply icon-down"></i>
                </div>
                <ul class="select">
                    <?php foreach ($record_cache as $value): ?>
                        <li class="option"><a href="<?= Url::record($value['date']) ?>"><?= $value['record'] ?>（<?= $value['lognum'] ?>）</a></li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
    </div>
<?php } ?>

<?php
/**
 * 侧边栏：自定义组件
 */
function widget_custom_text($title, $content)
{
?>
    <div class="box modularity aside-puzzle">
        <div class="modul-head">
            <div class="modul-title">
                <i class="icon-simply icon-puzzle mr-5"></i><?= $title ?>
            </div>
            <div class="colorful-dot"></div>
        </div>
        <div class="modul-body">
            <?= $content ?>
        </div>
    </div>
<?php } ?>

<?php
/**
 * 文章列出卡片：置顶标志
 */
function topflg($top, $sortop = 'n', $sortid = null)
{
    $ishome_flg = '<span title="首页置顶" class="badge">置顶</span>';
    $issort_flg = '<span title="分类置顶" class="badge">置顶</span>';
    if (blog_tool_ishome()) {
        return $top == 'y' ? $ishome_flg : '';
    } elseif ($sortid) {
        return $sortop == 'y' ? $issort_flg : '';
    }
}

?>

<?php
/**
 * 管理员：编辑文章
 */
function editflg($logid, $author, $text = '编辑')
{
    $editflg = User::haveEditPermission() || $author == UID ? '<a class="edit" href="' . BLOG_URL . 'admin/article.php?action=edit&gid=' . $logid . '" target="_blank">' . $text . '</a>' : '';
    return $editflg;
}

?>

<?php
/**
 * 获取分类
 */
function simply_sort($sortID, $icon = true, $link = true)
{
    $Sort_Model = new Sort_Model();
    $r = $Sort_Model->getOneSortById($sortID);
    $sortName = isset($r['sortname']) ? $r['sortname'] : '';
?>
    <?php if (!empty($sortName)) { ?>
        <?php if ($link): ?><a class="sort" href="<?= Url::sort($sortID) ?>"><?php endif; ?>
            <?php if ($icon): ?><i class="icon-simply icon-category mr-3"></i><?php endif; ?><?= $sortName ?>
                <?php if ($link): ?></a><?php endif; ?>
    <?php } else { ?>
        <?php if ($icon): ?><span class="sort"><i class="icon-simply icon-category mr-3"></i><?php endif; ?>默认分类</span>
    <?php }
} ?>

    <?php
    /**
     * 获取标签
     */
    function blog_tag($blogid, $icon = true)
    {
        $tag_model = new Tag_Model();
        $tag_ids = $tag_model->getTagIdsFromBlogId($blogid);
        $tag_names = $tag_model->getNamesFromIds($tag_ids);
        if (!empty($tag_names)) {
            $tag = '';
            foreach ($tag_names as $value) {
                $tag .= '<a class="tag" href="' . Url::tag(rawurlencode($value)) . '">';
                $tag .= $icon ? '<i class="icon-simply icon-tag mr-3"></i>' : '';
                $tag .= htmlspecialchars($value);
                $tag .= '</a>';
            }
            return $tag;
        }
    }

    ?>

    <?php
    /**
     * 获取作者
     */
    function blog_author($uid, $icon = true, $link = true)
    {
        $User_Model = new User_Model();
        $user_info = $User_Model->getOneUser($uid);
        $author = $user_info['nickname'];
        $echo_author = '';
        $echo_author .= $link ? '<a class="author" href="' . Url::author($uid) . '">' : '';
        $echo_author .= $icon ? '<i class="icon-simply icon-author mr-3"></i>' : '';
        $echo_author .= $author;
        $echo_author .= $link ? '</a>' : '';
        return $echo_author;
    }

    ?>

    <?php
    /**
     * 文章详情页：相邻文章
     */
    function neighbor_log($neighborLog)
    {
        extract($neighborLog);
        $neighbor = '<ul class="flex-v-between neighbor-items">';
        $neighbor .= '<li class="item">';
        $neighbor .= $prevLog ? '<a href="' . Url::log($prevLog['gid']) . '" title="' . $prevLog['title'] . '">上一篇</a>' : '<a class="disabled" title="没有了~">上一篇</a>';
        $neighbor .= '</li>';
        $neighbor .= '<li class="item">';
        $neighbor .= $nextLog ? '<a href="' . Url::log($nextLog['gid']) . '" title="' . $nextLog['title'] . '">下一篇</a>' : '<a class="disabled" title="没有了~">下一篇</a>';
        $neighbor .= '</li>';
        $neighbor .= '</ul>';
        return $neighbor;
    }

    ?>

    <?php
    /**
     * 文章详情页：评论列表
     */
    function blog_comments($comments, $allow_remark)
    {
        extract($comments);
        $isGravatar = Option::get('isgravatar');
        $reply = false;
        if (
            // 开启（设置 > 开启评论）
            Option::get('iscomment') == 'y' &&

            // 关闭（设置 > 登录后评论） || 用户已登录
            (Option::get('login_comment') == 'n' || ISLOGIN == 1) &&

            // 开启（文章 > 允许评论）
            $allow_remark == 'y'
        ) {
            $reply = true;
        }
    ?>
        <div class="comment-items">
            <?php
            foreach ($commentStacks as $cid):
                $comment = $comments[$cid];
                $avatar = getEmUserAvatar($comment['uid'], $comment['mail']);
            ?>
                <div class="display-flex comment-item" id="comment-<?= $comment['cid'] ?>">
                    <div class="mr-10 avatar">
                        <img src="<?= $avatar ?>" alt="$comment['poster']">
                    </div>
                    <div class="item-right">
                        <div class="flex-v-between item-user">
                            <div class="flex-v-center user">
                                <?php if ($comment['url']): ?>
                                    <a href="<?= $comment['url'] ? $comment['url'] : '' ?>"><?= $comment['poster'] ?></a>
                                <?php else: ?>
                                    <?= $comment['poster'] ?>
                                <?php endif; ?>
                                <?php if (_g('simply_comment_user_level')): ?>
                                    <div class="user-level ml-10"><i class="icon-simply icon-v mr-2"></i><?= $comment['level'] ?></div>
                                <?php endif; ?>
                            </div>
                            <div class="info">
                                <?php if (_g('simply_comment_user_geographic')): ?>
                                    <?php if (!empty($comment['ip'])): ?><?= $comment['ip'] ?> <i class="icon-simply icon-dot"></i><?php endif; ?>
                            <?php endif; ?>
                            <?php if (_g('simply_comment_user_agent')): ?>
                                <?= get_client_browser($comment['agent']) . '<i class="icon-simply icon-dot"></i>' . get_client_os($comment['agent']) ?>
                            <?php endif; ?>
                            </div>
                        </div>
                        <div class="message comment-content"><?= $comment['content'] ?></div>
                        <div class="mt-10 display-flex comment-timeReply">
                            <div class="comment-time mr-10"><?= $comment['date'] ?></div>
                            <?php if ($reply): ?><a class="comment-reply" href="javascript:;" target="_self" data-pid="<?= $comment['cid'] ?>"><i class="icon-simply icon-write mr-2"></i>回复</a><?php endif; ?>
                        </div>
                        <?php blog_comments_children($comments, $comment['children'], $reply) ?>
                    </div>
                </div>
            <?php endforeach ?>
        </div>
        <div class="pagination">
            <?= $commentPageUrl ?>
        </div>
    <?php } ?>

    <?php
    /**
     * 文章详情页：子评论
     */
    function blog_comments_children($comments, $children, $reply)
    {
        foreach ($children as $child):
            $comment = $comments[$child];
            $avatar = getEmUserAvatar($comment['uid'], $comment['mail']);
    ?>
            <div class="display-flex comment-item" id="comment-<?= $comment['cid'] ?>">
                <div class="mr-10 avatar">
                    <img src="<?= $avatar ?>" alt="$comment['poster']">
                </div>
                <div class="item-right">
                    <div class="flex-v-between item-user">
                        <div class="flex-v-center user">
                            <?php if ($comment['url']): ?>
                                <a href="<?= $comment['url'] ? $comment['url'] : '' ?>"><?= $comment['poster'] ?></a>
                            <?php else: ?>
                                <?= $comment['poster'] ?>
                            <?php endif; ?>
                            <?php if (_g('simply_comment_user_level')): ?>
                                <div class="user-level ml-10"><i class="icon-simply icon-v mr-2"></i><?= $comment['level'] ?></div>
                            <?php endif; ?>
                        </div>
                        <div class="info">
                            <?php if (_g('simply_comment_user_geographic')): ?>
                                <?= $comment['ip'] ?> <i class="icon-simply icon-dot"></i>
                            <?php endif; ?>
                            <?php if (_g('simply_comment_user_agent')): ?>
                                <?= get_client_browser($comment['agent']) . '<i class="icon-simply icon-dot"></i>' . get_client_os($comment['agent']) ?>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="message comment-content"><?= $comment['content'] ?></div>
                    <div class="mt-10 display-flex comment-timeReply">
                        <div class="comment-time mr-10"><?= $comment['date'] ?></div>
                        <?php if ($reply): ?><a class="comment-reply" href="javascript:;" target="_self" data-pid="<?= $comment['cid'] ?>"><i class="icon-simply icon-write mr-2"></i>回复</a><?php endif; ?>
                    </div>
                    <?php blog_comments_children($comments, $comment['children'], $reply) ?>
                </div>
            </div>
        <?php endforeach ?>
    <?php } ?>

    <?php
    /**
     * 文章详情页：评论表单
     */
    function blog_comments_post($logid, $ckname, $ckmail, $ckurl, $verifyCode, $allow_remark)
    {
        $isNeedChinese = Option::get('comment_needchinese');
    ?>
        <div class="comment-title">评论</div>
        <div class="my-2em comment-body">
            <?php if (Option::get('iscomment') == 'n'): ?>
                <div class="comment-closed">博主关闭了评论</div>
            <?php elseif ($allow_remark == 'n'): ?>
                <div class="comment-closed">博主关闭了当前页面的评论</div>
            <?php elseif (Option::get('login_comment') == 'y' && ISLOGIN != 1): ?>
                <div class="comment-login">
                    <div class="head">博主开启了登录后再评论，请登录后刷新本页！</div>
                    <div class="body mt-1em flex-center">
                        <a class="button mx-1em" id="ajax-signin" href="<?= BLOG_URL ?>admin/">立即登录</a>
                        <a class="button mx-1em" id="ajax-signup" href="<?= BLOG_URL ?>admin/account.php?action=signup">注册帐号</a>
                    </div>
                </div>
            <?php else: ?>
                <div class="comment-post">
                    <form class="flex-column layui-form comment-form" method="post" name="commentForm" action="<?= BLOG_URL ?>index.php?action=addcom" id="comment-form">
                        <input type="hidden" name="gid" value="<?= $logid ?>">
                        <input type="hidden" name="pid" value="">
                        <?php if (User::isVisitor() && Option::get('login_comment') === 'n'): ?>
                            <div class="display-flex head">
                                <input class="comment-control comment-name" autocomplete="off" type="text" name="comname" maxlength="49" value="<?= $ckname ?>" tabindex="1" placeholder="输入昵称（必填）" lay-verify="required">
                                <input class="comment-control comment-mail" autocomplete="off" type="text" name="commail" maxlength="128" value="<?= $ckmail ?>" tabindex="2" placeholder="电子邮箱" lay-verify="email">
                                <input class="comment-control comment-url" autocomplete="off" type="text" name="comurl" maxlength="128" value="<?= $ckurl ?>" tabindex="3" placeholder="个人主页" lay-verify="url">
                            </div>
                        <?php endif ?>
                        <div class="display-flex body">
                            <textarea class="comment-textarea" name="comment" rows="10" tabindex="4" placeholder="说点什么吧（必填）~" lay-verify="required<?php if ($isNeedChinese == 'y'): ?>|chinese<?php endif; ?>"></textarea>
                        </div>
                        <div class="display-flex flex-warp foot">
                            <a href="javascript:;" target="_self" class="color-theme text-v-center comment-cancle" style="display: none;">取消</a>
                            <?php if (!empty($verifyCode)): ?>
                                <div class="display-flex">
                                    <img class="captcha" id="captcha" src="<?= BLOG_URL ?>include/lib/checkcode.php" alt="更换验证码">
                                    <input name="imgcode" type="text" class="comment-control input-code mx-5" size="5" tabindex="5" placeholder="验证码" lay-verify="required">
                                </div>
                            <?php endif; ?>
                            <button type="submit" class="button comment-submit" tabindex="6" lay-submit lay-filter="comment">发送</button>
                        </div>
                    </form>
                </div>
            <?php endif; ?>
        </div>
    <?php } ?>

    <?php
    /**
     * 判断函数：是否是首页
     */
    function blog_tool_ishome()
    {
        if (BLOG_URL . trim(Dispatcher::setPath(), '/') == BLOG_URL) {
            return true;
        } else {
            return FALSE;
        }
    }

    function getEmUserAvatar($uid, $mail)
    {
        $avatar = '';
        if ($uid) {
            $userModel = new User_Model();
            $user = $userModel->getOneUser($uid);
            $avatar = $user['photo'];
        } elseif ($mail) {
            $avatar = getGravatar($mail);
        }
        return $avatar ?: BLOG_URL . "admin/views/images/avatar.svg";
    }

    ?>