<?php

!defined('EMLOG_ROOT') && exit('access denied!');

function plugin_setting_view()
{
    $plugin_storage = Storage::getInstance('em_image_watermark');
    $wm_pos = $plugin_storage->getValue('wm_pos');
    $wm_text = $plugin_storage->getValue('wm_text');
    $wm_fontsize = $plugin_storage->getValue('wm_fontsize');
    $wm_fontcolor = $plugin_storage->getValue('wm_fontcolor');
    $wm_type = $plugin_storage->getValue('wm_type');
    $wm_image = $plugin_storage->getValue('wm_image');
    $wm_image = getFileUrl($wm_image);
?>
    <?php if (isset($_GET['setting'])): ?>
        <div class="alert alert-success">设置成功</div>
    <?php endif; ?>
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">图片水印</h1>
    </div>
    <div class="card shadow mb-4 mt-2">
        <div class="card-body">
            <div class="alert alert-info">
                水印作用范围：发布文章上传图片 、资源管理上传图片。
            </div>
            <form action="./plugin.php?plugin=em_image_watermark&action=setting" method="POST" enctype="multipart/form-data">
                <div class="form-group">
                    <h4>水印位置</h4>
                    <table class="table table-bordered" style="width: 300px;">
                        <tr>
                            <td>
                                <label>
                                    <input type="radio" name="wm_pos" value="1" <?php if ($wm_pos == 1): ?>checked="checked" <?php endif; ?> />左上
                                </label>
                            </td>
                            <td>
                                <label>
                                    <input type="radio" name="wm_pos" value="2" <?php if ($wm_pos == 2): ?>checked="checked" <?php endif; ?> />中上
                                </label>
                            </td>
                            <td>
                                <label>
                                    <input type="radio" name="wm_pos" value="3" <?php if ($wm_pos == 3): ?>checked="checked" <?php endif; ?> />右上
                                </label>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label>
                                    <input type="radio" name="wm_pos" value="4" <?php if ($wm_pos == 4): ?>checked="checked" <?php endif; ?> />左中
                                </label>
                            </td>
                            <td>
                                <label>
                                    <input type="radio" name="wm_pos" value="5" <?php if ($wm_pos == 5): ?>checked="checked" <?php endif; ?> />中间
                                </label>
                            </td>
                            <td>
                                <label>
                                    <input type="radio" name="wm_pos" value="6" <?php if ($wm_pos == 6): ?>checked="checked" <?php endif; ?> />右中
                                </label>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label>
                                    <input type="radio" name="wm_pos" value="7" <?php if ($wm_pos == 7): ?>checked="checked" <?php endif; ?> />左下
                                </label>
                            </td>
                            <td>
                                <label>
                                    <input type="radio" name="wm_pos" value="8" <?php if ($wm_pos == 8): ?>checked="checked" <?php endif; ?> />中下
                                </label>
                            </td>
                            <td>
                                <label>
                                    <input type="radio" name="wm_pos" value="9" <?php if ($wm_pos == 9): ?>checked="checked" <?php endif; ?> />右下
                                </label>
                            </td>
                        </tr>
                    </table>
                </div>
                <div class="form-group">
                    <h4>水印类型</h4>
                    <label>
                        <input type="radio" name="wm_type" value="text" <?php if ($wm_type == 'text')
                                                                            echo 'checked'; ?> /> 文字水印
                    </label><br>
                    <label>
                        <input type="radio" name="wm_type" value="image" <?php if ($wm_type == 'image')
                                                                                echo 'checked'; ?> /> 图片水印
                    </label>
                </div>

                <div id="textWatermarkSettings" <?php if ($wm_type != 'text')
                                                    echo 'style="display: none;"'; ?>>
                    <div class="form-group">
                        <label for="watermarkText">水印文字</label>
                        <input type="text" class="form-control" name="wm_text" maxlength="30" value="<?php echo $wm_text; ?>" style="width:150px;" />
                    </div>

                    <div class="form-group">
                        <label for="textSize">文字大小（像素，如： 18）</label>
                        <input type="text" class="form-control" name="wm_fontsize" maxlength="2" value="<?php echo $wm_fontsize; ?>" style="width:100px;" />
                    </div>
                    <div class="form-group">
                        <label for="textColor">文字颜色（如红色:#FF0000, 蓝色：#0000FF）</label>
                        <input type="color" class="form-control" name="wm_fontcolor" maxlength="7" minlength="7" value="<?php echo $wm_fontcolor; ?>" style="width:100px;" />
                    </div>
                </div>

                <div id="imageWatermarkSettings" <?php if ($wm_type != 'image')
                                                        echo 'style="display: none;"'; ?>>
                    <?php if (!empty($wm_image)): ?>
                        <p><img src="<?= $wm_image ?>" style="max-width: 600px;"></p>
                    <?php endif; ?>
                    <div class="form-group">
                        <label for="watermarkImage">选择水印图片（仅支持 png 和 jpg 格式）</label>
                        <input type="file" class="" name="wm_image" />
                    </div>
                </div>
                <input type="submit" class="btn btn-primary" value="保 存" />
            </form>
        </div>
    </div>
    <script>
        setTimeout(hideActived, 3600);
        $("#menu_category_ext").addClass('active');
        $("#menu_ext").addClass('show');
        $("#menu_plug").addClass('active');

        $('input[name="wm_type"]').change(function() {
            if (this.value === 'text') {
                $('#textWatermarkSettings').show();
                $('#imageWatermarkSettings').hide();
            } else if (this.value === 'image') {
                $('#textWatermarkSettings').hide();
                $('#imageWatermarkSettings').show();
            }
        });
    </script>
<?php
}

function plugin_setting()
{
    $plugin_storage = Storage::getInstance('em_image_watermark');
    $wm_pos = Input::postIntVar('wm_pos');
    $wm_text = Input::postStrVar('wm_text');
    $wm_fontsize = Input::postIntVar('wm_fontsize');
    $wm_fontcolor = Input::postStrVar('wm_fontcolor');
    $wm_type = Input::postStrVar('wm_type');

    $attach = isset($_FILES['wm_image']) ? $_FILES['wm_image'] : '';
    if ($attach && $attach['error'] !== 4) {
        upload2local($attach, $ret);
        if (empty($ret['success'])) {
            emMsg('水印图上传失败');
        }
        $plugin_storage->setValue('wm_image', $ret['file_info']['file_path']);
    }

    $plugin_storage->setValue('wm_pos', $wm_pos);
    $plugin_storage->setValue('wm_text', $wm_text);
    $plugin_storage->setValue('wm_fontsize', $wm_fontsize);
    $plugin_storage->setValue('wm_fontcolor', $wm_fontcolor);
    $plugin_storage->setValue('wm_type', $wm_type);
}
