<?php
/*
Plugin Name: 浏览记录
Version: 1.2
Plugin URL: https://www.emlog.net/plugin/detail/633
Description: 访客可以看到浏览过的文章
Author: 五哥
Author Email: 497399374@qq.com
Author URL: https://www.emlog.net/author/index/1706
*/
!defined('EMLOG_ROOT') && exit('access deined!');

addAction('index_head', function (){
?>
<script>
var histData = function(table, settings, storage){
    table = table || 'yyhist';
    storage = storage || localStorage;

    if(!window.JSON || !window.JSON.parse) return;
    if(settings === null){
      return delete storage[table];
    }

    settings = typeof settings === 'object'
      ? settings
    : {key: settings};

    try {
      var data = JSON.parse(storage[table]);
    } catch(e) {
      var data = {};
    }

    if('value' in settings) data[settings.key] = settings.value;
    if(settings.remove) delete data[settings.key];
    storage[table] = JSON.stringify(data);

    return settings.key ? data[settings.key] : data;
};
</script>
<?php
});

addAction('log_related', 'addHistory');
function addHistory($logData){
?>
<script>
var hists = histData('yyhist')['<?=date("Y/m/d")?>'] || {};
hists['<?=$logData['logid']?>'] = {title: '<?=$logData['log_title']?>', date: '<?=date('H:i:s')?>'};
histData('yyhist',{
    key: '<?=date("Y/m/d")?>',
    value: hists
});
</script>
<?php
}


addAction('index_footer', 'yyhist');
function yyhist(){
?>
<div class="yyhist-mark" id="yyMark"></div><div class="yyhist anim anim-slide-left"><div class="yyhistory-head">我的足迹<span id="delHost" class="delHost" title="清空历史记录">清空</span></div><div class="yyhistory-body"><ul></ul></div></div>
<style>
.historyBtn{cursor: pointer;z-index: 999;line-height: 16px;font-size: 14px;position:fixed;right:0;width:22px;text-align:center;top:50%;transform:translate(0,-50%);-webkit-transform:translate(0,-50%);border:1px solid rgb(137 137 137 / 20%);background-color:white;color:black;padding:15px 3px;margin-right:-1px;border-radius:10px 0 0 10px;box-shadow:0px 0px 20px rgb(0 0 0 / 20%)}.yyhist-mark{position:fixed;z-index:920103;top:0;right:0;left:0;bottom:0;background:rgba(0,0,0);display:none;opacity:0.1}.yyhist *{list-style-type:none;text-decoration:none;margin:0;padding:0}.yyhist{background-color:#fafafa;color:#2f363c;display:none;position:fixed;right:0;top:0;bottom:0;width:350px;z-index:920104;font-size:14px;padding-top:50px;box-shadow:1px 1px 50px rgb(0 0 0 / 30%)}.yyhist .yyhistory-head{line-height:50px;text-align:left;padding:0 15px;border-bottom:1px solid #dddddd;position:absolute;top:0;left:0;right:0;z-index:5;font-size:16px;font-weight:bold}.yyhist .yyhistory-head .delHost{float:right;font-size:14px;color:#919191;font-weight:initial;cursor:pointer;padding:0 8px}.yyhist .yyhistory-body{position:absolute;top:51px;right:0;left:0;bottom:0;overflow-x:hidden;overflow-y:auto}.yyhist ul{overflow:hidden}.yyhist ul li{padding:10px 0;overflow:hidden;text-align:left}.yyhist ul li span{display:block;line-height:18px;font-size:14px;border-left:3px solid #16baaa;padding:0 15px}.yyhist ul li a{display:block;padding:4px;line-height:20px;color:#16baaa;margin-left:15px}.yyhist ul li a em{margin-right:10px;font-size:12px;color:#7c7c7c}.yyhist ul li+li{border-top:1px solid #ebebeb}.yyhist .emptyHist{text-align:center;margin:80px 0;font-size:16px;color:#8f8f8f}.anim{-webkit-animation-fill-mode:both;animation-fill-mode:both;-webkit-animation-duration:.3s;animation-duration:.3s}@keyframes slide-left{from{transform:translate3d(100%,0,0)}to{transform:translate3d(0,0,0)}}@keyframes slide-left-out{from{transform:translate3d(0,0,0)}to{transform:translate3d(100%,0,0)}}.anim-slide-left{animation-name:slide-left}.anim-slide-left-out{animation-name:slide-left-out}
</style>
<script>
$(function(){
    $(document).on('click','[yyid=yyhist]',function(){
        $('.yyhist,#yyMark').fadeIn();
        var histdata = histData('yyhist') || {},
            html = '';
        if(Object.keys(histdata).length > 0){
            for(var t in histdata){
                const sortedEntries = Object.entries(histdata[t])
                    .map(([id, entry]) => ({
                        id,
                        title: entry.title,
                        date: entry.date,
                        timestamp: `${t.replace(/\//g, '-')} ${entry.date}`
                    }))
                    .sort((a, b) => new Date(b.timestamp) - new Date(a.timestamp));
                html +='<li>';
                html +='<span>'+t+'</span>';
                
                for(var i in sortedEntries){
                    html +='<a href="'+BLOG_URL+'?post='+sortedEntries[i].id+'"><em>'+sortedEntries[i].date+'</em>'+sortedEntries[i].title+'</a>';
                }
                html +='</li>';
            }
        }else{
            html += '<div class="emptyHist">暂无历史记录！</div>';
        }
        $('.yyhist ul').html(html);
        $('body').css('overflow','hidden');
    });
    $(document).on('click','#yyMark',function(){
        $('.yyhist').addClass('anim-slide-left-out').fadeOut(200);
        $('#yyMark').fadeOut(500);
        setTimeout( function(){
		    $('body').css('overflow','auto');
            $('.yyhist').removeClass('anim-slide-left-out');
        }, 300);
    });
    $(document).on('click','#delHost',function(){
        if(confirm("是否清空浏览历史？")){
            histData('yyhist', null);
            $('.yyhist ul').html('<div class="emptyHist">暂无历史记录！</div>');
        }
    });
    if($('[yyid=yyhist]').length<=0){
        $('body').append('<div class="historyBtn" id="historyBtn" yyid="yyhist">浏览足迹</div>');
    }
});
</script>

<?php
}