<?php

/**
 * 首页模板
 */
defined('EMLOG_ROOT') || exit('access denied!');
?>

<?php
// 内页
if ($pageurl != Url::logPage()):
?>
    <div class="container container-path">
        <div class="web-path">
            <?php
            $path_route = '默认';
            $path_value = '列表';
            if (isset($tag)) {
                $path_route = '标签';
                $path_value = $tag;
            }
            if (isset($sortid)) {
                global $CACHE;
                $sort_cache = $CACHE->readCache('sort');
                $path_route = $sort_cache[$sortid]['sortname'];
                $path_value = '列表';
            }
            if (isset($author)) {
                $path_route = '作者';
                $path_value = blog_author($author, false, false);
            }
            if (isset($keyword)) {
                $path_route = '搜索';
                $path_value = $keyword;
            }
            if (isset($record)) {
                $path_route = '存档';
                $path_value = $record;
            }
            ?>
            <i class="icon-simply icon-home mr-5"></i><a class="path" href="<?= BLOG_URL ?>">首页</a><span class="path"><?= $path_route ?></span><span class="path"><?= $path_value ?></span>
        </div>
    </div>
<?php endif; ?>

<div class="container frame-container<?php if ($pageurl != Url::logPage()): ?> container-list<?php endif; ?>">
    <main class="box frame-main">
        <?php
        if ($pageurl == Url::logPage() || blog_tool_ishome()) {
            include View::getView('recommend');
        };
        ?>
        <div class="modularity modularity-list">
            <?php if ($pageurl == Url::logPage()): ?>
                <div class="modul-head">
                    <ul class="flex-list">
                        <li class="item active">最新文章</li>
                    </ul>
                    <?php
                    $data_adv_text = studio_string_to_array('simply_index_adv_text', 0, 2);
                    if (!empty($data_adv_text)):
                    ?>
                        <ul class="flex-list">
                            <?php foreach ($data_adv_text as $item): ?>
                                <li class="item">
                                    <a href="<?= trim($item[1]) ?>" target="_blank"><?= trim($item[0]) ?></a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <div class="modul-body">
                <ul class="article-list">
                    <?php
                    doAction('index_loglist_top');
                    if (!empty($logs)):
                        foreach ($logs as $value):
                    ?>
                            <li class="item">
                                <?php $value['log_cover'] = $value['log_cover'] ?: _g('simply_global_thumb'); ?>
                                <div class="thumbnail">
                                    <a class="percent-image" href="<?= $value['log_url'] ?>">
                                        <figure class="figure">
                                            <img src="<?= $value['log_cover'] ?>" alt="<?= $value['log_title'] ?>" />
                                        </figure>
                                    </a>
                                </div>
                                <div class="infomation">
                                    <h3 class="title">
                                        <?= topflg($value['top'], $value['sortop'], isset($sortid) ? $sortid : '') ?>
                                        <a href="<?= $value['log_url'] ?>"><?= $value['log_title'] ?></a>
                                        <?= editflg($value['logid'], $value['author'], '<i class="icon-simply icon-edit ml-5"></i>') ?>
                                    </h3>
                                    <div class="description"><?= sub_string(strip_html_tags($value['log_description']), 200) ?></div>
                                    <ul class="flex-list meta">
                                        <li class="item sort">
                                            <?= simply_sort($value['sortid']) ?>
                                        </li>
                                        <li class="item time">
                                            <i class="icon-simply icon-time mr-3"></i><?= date('Y-n-j H:i', $value['date']) ?>
                                        </li>
                                        <li class="item view">
                                            <i class="icon-simply icon-view mr-3"></i><?= $value['views'] ?>
                                        </li>
                                        <li class="item comt">
                                            <a href="<?= $value['log_url'] ?>#comment"><i class="icon-simply icon-message mr-3"></i><?= $value['comnum'] ?></a>
                                        </li>
                                    </ul>
                                </div>
                            </li>
                        <?php
                        endforeach;
                    else:
                        ?>
                        <div class="flex-center empty-box">抱歉，暂时还没有内容。</div>
                    <?php endif ?>
                </ul>
                <div class="pagination">
                    <?= $page_url ?>
                </div>
            </div>
        </div>
    </main>
    <aside class="frame-aside">
        <?php include View::getView('side'); ?>
    </aside>
</div>
<div class="container">
    <?= widget_link('友情链接') ?>
</div>
<?php include View::getView('footer'); ?>