<?php

/**
 * Database operation routing
 *
 * @package EMLOG
 * @link https://www.emlog.net
 */

class Database
{

    public static function getInstance($dbtype=DB_TYPE)
    {
        if (defined('USE_MYSQL_PDO') && USE_MYSQL_PDO === true) {
            if (class_exists('pdo', false)) {
                return DatabasePDO::getInstance($dbtype);
            } else {
                emMsg('服务器PHP未启用PDO扩展。');
            }
        } else {
            

            if (class_exists('pdo', false)) {
                return DatabasePDO::getInstance($dbtype);
            }
if (class_exists('mysqli', FALSE)) {
                return MySqlii::getInstance($dbtype);
            }
            emMsg('服务器PHP不支持MySQL数据库扩展。');
        }
    }
}
