<?php
/*
Plugin Name: 网站公告栏
Version: 1.1
Plugin URL: https://www.emlog.net/plugin/detail/875
Description: 在网站显示弹窗公告，支持后台管理公告内容。
Author: 领航云工作室
Author URL: https://www.emlog.net/author/index/6788
*/

!defined('EMLOG_ROOT') && exit('access denied!');

// 添加前台页面头部js和css
addAction('index_head', 'lh_gonggao_header');
function lh_gonggao_header() {
    $plugin_url = BLOG_URL . 'content/plugins/lh_gonggao/';
    echo '<link rel="stylesheet" href="' . $plugin_url . 'style.css">';
    echo '<script src="' . $plugin_url . 'lh_gonggao.js"></script>';
}

// 添加前台页面底部公告显示
addAction('index_loglist_top', 'lh_gonggao_show'); 
function lh_gonggao_show() {
    // 判断是否在首页
    if (BLOG_URL . trim(Dispatcher::setPath(), '/') !== BLOG_URL) {
        return;
    }
    
    $plugin_storage = Storage::getInstance('lh_gonggao');
    $notice = $plugin_storage->getValue('current_notice');
    if (empty($notice)) {
        return;
    }
    $notice = json_decode($notice, true);
    if ($notice['status'] != 'active') {
        return;
    }
    ?>
    <div class="notice-bar" style="background-color: <?= isset($notice['bg_color']) ? $notice['bg_color'] : '#ffffff' ?>">
        <div class="notice-bar-content" style="color: <?= isset($notice['font_color']) ? $notice['font_color'] : '#333333' ?>">
            <?php if (!empty($notice['title'])): ?>
                <span class="notice-title" style="color: inherit"><?= $notice['title'] ?> </span>
            <?php endif; ?>
            <?php if (!empty($notice['content'])): ?>
                <span class="notice-text" style="color: inherit"><?= $notice['content'] ?></span>
            <?php endif; ?>
            <span class="notice-date" style="color: inherit"><?= $notice['date'] ?></span>
            <span class="notice-close" style="color: inherit">&times;</span>
        </div>
    </div>
    <?php
}

// 可以移除或注释掉 callback_init() 函数，因为现在使用 lh_gonggao_show() 来显示公告 