<?php
!defined('EMLOG_ROOT') && exit('access denied!');

function plugin_setting_view() {
    $plugin_storage = Storage::getInstance('lh_gonggao');
    $notice = $plugin_storage->getValue('current_notice');
    $notice = !empty($notice) ? json_decode($notice, true) : array();
    
    if (isset($_POST['notice_submit'])) {
        $new_notice = array(
            'title' => Input::postStrVar('notice_title'),
            'content' => Input::postStrVar('notice_content'),
            'date' => date('Y-m-d H:i:s'),
            'status' => Input::postStrVar('notice_status', 'inactive'),
            'bg_color' => Input::postStrVar('bg_color', '#ffffff'),
            'font_color' => Input::postStrVar('font_color', '#333333')
        );
        $plugin_storage->setValue('current_notice', json_encode($new_notice));
        emMsg('公告更新成功');
    }
    
    // 处理删除公告请求
    if (isset($_POST['notice_delete'])) {
        $plugin_storage->deleteAllName('YES');
        $default_notice = array(
            'title' => '欢迎使用公告栏插件',
            'content' => '这是一条默认公告，请在后台设置您的公告内容。',
            'date' => date('Y-m-d H:i:s'),
            'status' => 'inactive',
            'bg_color' => '#ffffff',
            'font_color' => '#333333'
        );
        $plugin_storage->setValue('current_notice', json_encode($default_notice));
        emMsg('公告已重置为默认状态');
    }
    ?>
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">公告管理</h1>
    </div>
    <div class="card shadow mb-4">
        <div class="card-body">
            <form method="post" action="">
                <div class="form-group">
                    <label for="notice_title">公告标题</label>
                    <input type="text" class="form-control" id="notice_title" name="notice_title" value="<?= isset($notice['title']) ? $notice['title'] : '' ?>">
                </div>
                <div class="form-group">
                    <label for="notice_content">公告内容</label>
                    <textarea class="form-control" id="notice_content" name="notice_content" rows="5"><?= isset($notice['content']) ? $notice['content'] : '' ?></textarea>
                </div>
                <div class="form-group">
                    <label>公告状态</label>
                    <div class="custom-control custom-radio">
                        <input type="radio" class="custom-control-input" id="status_active" name="notice_status" value="active" <?= (isset($notice['status']) && $notice['status'] == 'active') ? 'checked' : '' ?>>
                        <label class="custom-control-label" for="status_active">启用</label>
                    </div>
                    <div class="custom-control custom-radio">
                        <input type="radio" class="custom-control-input" id="status_inactive" name="notice_status" value="inactive" <?= (isset($notice['status']) && $notice['status'] == 'inactive') ? 'checked' : '' ?>>
                        <label class="custom-control-label" for="status_inactive">禁用</label>
                    </div>
                </div>
                <div class="form-group">
                    <label>背景颜色</label>
                    <input type="color" class="form-control" name="bg_color" value="<?= isset($notice['bg_color']) ? $notice['bg_color'] : '#ffffff' ?>" style="width: 100px;">
                </div>
                <div class="form-group">
                    <label>字体颜色</label>
                    <input type="color" class="form-control" name="font_color" value="<?= isset($notice['font_color']) ? $notice['font_color'] : '#333333' ?>" style="width: 100px;">
                </div>
                <div class="form-group">
                    <button type="submit" name="notice_submit" class="btn btn-primary">保存公告</button>
                    <button type="submit" name="notice_delete" class="btn btn-danger ml-2" onclick="return confirm('确定要重置公告吗？这将删除当前公告并恢复为默认状态。')">重置公告</button>
                </div>
            </form>
        </div>
    </div>
    <?php

    if (isset($_POST['notice_submit'])) {
        $bg_color = isset($_POST['bg_color']) ? $_POST['bg_color'] : '#ffffff';
        Option::updateOption('lh_gonggao_bg_color', $bg_color);
    }
} 