const toolbar = [
  "emoji",
  "headings",
  "bold",
  "italic",
  "strike",
  "link",
  "|",
  "list",
  "ordered-list",
  "check",
  "outdent",
  "indent",
  "|",
  "quote",
  "line",
  "code",
  "inline-code",
  //"insert-before",
  //"insert-after",
  "|",
  {
    "name": "upload_file",
    "tip": "文件上传",
    "icon": `<svg t="1709474676585" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="9494" width="200" height="200"><path d="M833.47 337.03C804.22 187.15 672.62 73.83 511.77 73.83c-160.84 0-292.44 113.32-321.69 263.2C80.42 366.28 0 468.63 0 585.61c0 142.57 113.32 255.9 255.89 255.9h36.56v-73.12h-36.56c-102.35 0-182.78-80.42-182.78-182.78 0-102.35 80.42-182.78 182.78-182.78 0-142.57 113.32-255.89 255.89-255.89s255.9 113.32 255.9 255.89c102.35 0 182.78 80.42 182.78 182.78s-80.42 182.78-182.78 182.78h-36.56v73.12h36.56c142.57 0 255.89-113.33 255.89-255.9-0.01-116.98-80.44-219.33-190.1-248.58z m0 0" fill="#323333" p-id="9495"></path><path d="M544.68 486.91c-14.63-10.97-29.24-14.63-43.87-7.31-3.65 0-7.31 3.65-10.97 7.31L380.17 592.92c-14.62 14.63-14.62 36.56 0 51.18 14.63 14.63 40.21 14.63 54.84 0l43.86-40.21v310.73c0 21.93 18.28 36.55 36.56 36.55 21.93 0 36.55-18.27 36.55-36.55V603.88l43.87 40.21c14.62 14.63 40.21 14.63 54.83 0 14.63-14.62 14.63-36.55 0-51.18l-106-106z m0 0" fill="#323333" p-id="9496"></path></svg>`,
    click () {
      $("#mediaModal").modal('show')
    }
  },
  {
    "name": "video",
    "tip": "视频",
    "icon": `<svg t="1709815793173" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="4300" width="200" height="200"><path d="M704 320m-64 0a64 64 0 1 0 128 0 64 64 0 1 0-128 0Z" p-id="4301"></path><path d="M832 864H64a32 32 0 0 1-32-32V192a32 32 0 0 1 32-32h768a32 32 0 0 1 32 32v140.16l81.92-40.96a32.64 32.64 0 0 1 30.72 0 33.28 33.28 0 0 1 15.36 28.8v384a33.28 33.28 0 0 1-15.36 27.52 32.64 32.64 0 0 1-30.72 0l-81.92-40.96V832a32 32 0 0 1-32 32z m-736-64h704V640a33.28 33.28 0 0 1 15.36-27.52 32.64 32.64 0 0 1 30.72 0l81.92 40.96v-281.6l-81.92 40.96a32.64 32.64 0 0 1-30.72 0A33.28 33.28 0 0 1 800 384V224h-704z" p-id="4302"></path><path d="M384 672a33.92 33.92 0 0 1-15.36-3.84 32.64 32.64 0 0 1-16.64-28.16V384a32 32 0 0 1 49.92-26.88l192 128a32.64 32.64 0 0 1 0 53.76l-192 128a36.48 36.48 0 0 1-17.92 5.12z m32-228.48v136.96L518.4 512z" p-id="4303"></path></svg>`,
    click () {
      vditorInsertValue(`<video  class="yublog_video" controls>    <source src="">   </video>`)
    }
  },
  "table",
  "|",
  {
    "name": "mindmap",
    "tip": "脑图",
    "icon": `<svg t="1711835167533" class="icon" viewBox="0 0 1170 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="4420" width="200" height="200"><path d="M585.142857 827.099429h167.204572V708.900571H1170.285714V1024h-417.938285v-118.125714H585.142857c-46.153143 0-83.602286-35.328-83.602286-78.774857v-275.748572H417.938286c0 43.52-37.376 78.774857-83.602286 78.774857H83.602286C37.449143 630.125714 0 594.870857 0 551.350857V472.649143c0-43.52 37.449143-78.774857 83.602286-78.774857H334.262857c46.226286 0 83.602286 35.254857 83.602286 78.774857h83.602286v-275.748572c0-43.446857 37.449143-78.774857 83.602285-78.774857h167.204572V0H1170.285714v315.099429h-417.938285V196.900571H585.142857v630.198858z m250.806857 0v118.125714h250.733715V787.748571H836.022857v39.424z m0-708.973715v118.198857h250.733715V78.774857H836.022857v39.350857z" fill="#666666" p-id="4421"></path></svg>`,
    click () {
      vditorInsertValue('```mindmap \n - 教程 \n - 语法指导 \n - 普通内容 \n - 提及用户 \n```')
    }
  },
  {
    "name": "mermaid",
    "tip": "流程图",
    "icon": `<svg t="1711835360379" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="5426" width="200" height="200"><path d="M682.666667 42.666667a42.666667 42.666667 0 0 0-42.666667-42.666667H384a42.666667 42.666667 0 0 0-42.666667 42.666667v256a42.666667 42.666667 0 0 0 42.666667 42.666666h256a42.666667 42.666667 0 0 0 42.666667-42.666666V42.666667z m-85.333334 42.666666v170.666667h-170.666666V85.333333h170.666666zM341.333333 725.333333a42.666667 42.666667 0 0 0-42.666666-42.666666H42.666667a42.666667 42.666667 0 0 0-42.666667 42.666666v256a42.666667 42.666667 0 0 0 42.666667 42.666667h256a42.666667 42.666667 0 0 0 42.666666-42.666667v-256z m-85.333333 42.666667v170.666667H85.333333v-170.666667h170.666667zM1024 725.333333a42.666667 42.666667 0 0 0-42.666667-42.666666h-256a42.666667 42.666667 0 0 0-42.666666 42.666666v256a42.666667 42.666667 0 0 0 42.666666 42.666667h256a42.666667 42.666667 0 0 0 42.666667-42.666667v-256z m-85.333333 42.666667v170.666667h-170.666667v-170.666667h170.666667z" p-id="5427"></path><path d="M512 256a42.666667 42.666667 0 0 1 42.666667 42.666667v256a42.666667 42.666667 0 1 1-85.333334 0V298.666667a42.666667 42.666667 0 0 1 42.666667-42.666667z" p-id="5428"></path><path d="M896 554.666667a42.666667 42.666667 0 0 0-42.666667-42.666667H170.666667a42.666667 42.666667 0 0 0-42.666667 42.666667v170.666666h85.333333v-128h597.333334v128h85.333333v-170.666666z" p-id="5429"></path></svg>`,
    click () {
      vditorInsertValue('```mermaid \n graph TB \n c1-->a2 \n subgraph one \n a1-->a2 \n  end \n```')
    }
  },
  "|",
  "undo",
  "redo",
  "|",
  "fullscreen",
  "edit-mode",
  "outline",
  "preview",
  {
    name: "more",
    toolbar: [
      "both",
      "code-theme",
      "content-theme",
      "export",
      // "outline",
      "preview",
      "devtools",
      "info",
      "help",
    ],
  },
]

let monie_vditor = null
$(function () {
  // 笔记
  if ($('textarea[name="t"]').length > 0) return
  // 文章
  if (typeof Editor != 'undefined' && window.location.pathname.indexOf('article.php') != -1) {
    let logcontent_wrapper = $(`<div id="monie_logcontent">
  <div id="monie_logcontent_vditor"></div>
  <textarea name="logcontent" id="logcontent" style="display: none"></textarea>
</div>
  `)

    let editor_content = $('#logcontent textarea').val()

    // 简要可能只是一段介绍 官方的 md 就好 简单方便
    let editor_excerpt = $('#logexcerpt textarea').val()

    $('#logcontent').after(logcontent_wrapper)

    Editor.editor.remove()
    monie_vditor = new Vditor('monie_logcontent_vditor', {
      height: 720,
      value: editor_content,
      toolbar: toolbar,
      cache: {
        enable: false
      },
      mode: 'wysiwyg',
      // 计数器
      counter: {
        enable: true,
      },
      after () {
        $('#logcontent').val(editor_content)


        if (/Mobi|Android|iPhone/i.test(navigator.userAgent)) {
          // 当前设备是移动设备
          // 粘贴上传图片 借鉴了官方的思路 
          // TODO 1 上传进度 2 代码优化 
          document.querySelector('[data-mode="ir"]').addEventListener('click', (e) => {
            let dom = monie_vditor['vditor'][monie_vditor['vditor'].currentMode].element
            resetUploadImg(dom)
          })
          document.querySelector('[data-mode="sv"]').addEventListener('click', (e) => {
            let dom = monie_vditor['vditor'][monie_vditor['vditor'].currentMode].element
            resetUploadImg(dom)
          })
          let dom = monie_vditor['vditor'][monie_vditor['vditor'].currentMode].element
          resetUploadImg(dom)
        }

      },
      blur (value) {
        $('#logcontent').val(value)
      },
      // 为兼容 ctrl + s 保存内容
      keydown (e) {
        if ((e.key == 's' || e.key == 'S') && (navigator.userAgent.match("Macintosh") ? e.metaKey : e.ctrlKey)) {
          e.preventDefault()
          let value = monie_vditor.getValue()
          $('#logcontent').val(value)
        }
      },

      upload: {
        linkToImgUrl: '/?plugin=vditor',
        linkToImgFormat (responseText) {
          const response = JSON.parse(responseText)
          let src = response.data.originalURL
          let urlparams = src.split('?')
          let ret = urlparams[0].split('/')
          let name = ret[ret.length - 1]
          return responseText
        }
      }
    })
  }
})


function getFileFromUrl (url, fileName) {
  return new Promise((reslove, reject) => {
    var blob = null
    var xhr = new XMLHttpRequest()
    xhr.open("GET", url)
    xhr.responseType = "blob"
    // 加载时处理
    xhr.onload = () => {
      // 获取返回结果
      blob = xhr.response
      let file = new File([blob], fileName, { type: blob.type })
      // 返回结果
      reslove(file)
    }
    xhr.onerror = (e) => {
      reject(e)
    }
    // 发送
    xhr.send()
  })
}


function resetUploadImg (dom) {
  dom.addEventListener('paste', (e) => {

    // 防止默认行为
    e.preventDefault()

    if (!(e.clipboardData && e.clipboardData.items)) return

    var pasteData = e.clipboardData || window.clipboardData // 获取剪切板里的全部内容
    pasteAnalyseResult = new Array  // 用于储存遍历分析后的结果

    for (var i = 0; i < pasteData.items.length; i++) {  // 遍历分析剪切板里的数据
      var item = pasteData.items[i]

      if ((item.kind == "file") && (item.type.match('^image/'))) {
        var imgData = item.getAsFile()
        if (imgData.size === 0) return
        pasteAnalyseResult['type'] = 'img'
        pasteAnalyseResult['data'] = imgData
        break  // 当粘贴板中有图片存在时,跳出循环
      }
      ;
    }

    if (pasteAnalyseResult['type'] == 'img') {  // 如果剪切板中有图片,上传图片

      monie_vditor.disabled()
      uploadImg(pasteAnalyseResult['data'])
      return
    }
  }, false)
}

function uploadImg (img) {
  let postUrl = '/admin/media.php?action=upload'  // emlog 的图片上传地址
  let emMediaPhpUrl = "/admin/media.php?action=lib"  // emlog 的资源库地址,用于异步获取上传后的图片数据

  var formData = new FormData()
  var imgName = "粘贴上传" + new Date().getTime() + "." + img.name.split(".").pop()
  formData.append('file', img, imgName)
  cocoMessage.success('正在上传')
  $.ajax({
    url: postUrl, type: 'post', data: formData, processData: false, contentType: false, success (res) {
      // 成功
      monie_vditor.enable()
      $.get(emMediaPhpUrl, function (resp) {
        var image = resp.data.images[0]
        if (image) {
          console.log('获取结果成功！')
          vditorInsertValue(`[![](${image.media_icon})](${image.media_url})`)
        } else {
          console.log('获取结果失败！')
          cocoMessage.error("获取失败", 4000)
        }
      })
    }, error () {
      // 失败
      cocoMessage.error("上传失败类型错误", 4000)
      monie_vditor.enable()
    }
  })
}


// vditorInsertValue
function vditorInsertValue (value, render = true) {
  // monie_vditor.focus()
  monie_vditor.insertValue(value, render)
}

function insert_media_img (fileurl, filethumurl) {
  vditorInsertValue(`![](${fileurl})`)
  cocoMessage.success('图片插入编辑器成功!')
}

function insert_media (fileurl, filename) {
  if (fileurl.indexOf('.mp3') != -1 || fileurl.indexOf('.m4a') != -1) {
    vditorInsertValue('<audio src="' + fileurl + '" controls width="100%"></audio>')
    cocoMessage.success('音乐插入编辑器成功!')

  } else {
    vditorInsertValue('<a href="' + fileurl + '" target="_blank">' + filename + '</a>')
    cocoMessage.success('附件插入编辑器成功!')
  }
}

function insert_media_audio (fileurl) {
  vditorInsertValue('<audio src="' + fileurl + '" controls width="100%"></audio>')
  cocoMessage.success('音乐插入编辑器成功!')
}

function insert_media_video (fileurl) {
  // class 请勿删除 为以后添加播放器
  vditorInsertValue(`<video controls class="yulog_video"><source src="${fileurl}"></source></video>`)
  cocoMessage.success('视频插入编辑器成功!')
}

