<?php
/*
Plugin Name: 文章目录
Version: 1.3
Plugin URL:https://www.zxki.cn/
Description: 在文章头部添加目录,实现快速导航.
Author: 酷库博客
Author URL: https://www.emlog.net/author/index/1975
*/

!defined('EMLOG_ROOT') && exit('access denied!');

function x_nav(){
    $plugin_storage = Storage::getInstance('x_nav');
    $x_nav_class = $plugin_storage->getValue('class');
    
    echo <<<EOT
<aside class="x_nav_nav">
    <div class="x_nav_icon">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
            <line x1="17" y1="10" x2="3" y2="10"></line>
            <line x1="21" y1="6" x2="3" y2="6"></line>
            <line x1="21" y1="14" x2="3" y2="14"></line>
            <line x1="17" y1="18" x2="3" y2="18"></line>
        </svg>
        <span class="x_nav_title">目录</span>
    </div>
</aside>
<div class="x_nav_page_toc">
    <ul class="x_nav_anchor-list"></ul>
</div>
<div class="overlay"></div>

<style type='text/css'>
.x_nav_nav {
    position: fixed;
    top: 50%;
    left: 0;
    transform: translateY(-50%);
    padding: 0.5rem;
    background-color: #ffffff;
    box-shadow: 2px 0 4px rgba(0, 0, 0, 0.1);
    z-index: 100;
    width: 60px;
    border-radius: 0px 15px 15px 0px;
    transition: opacity 0.2s ease;
}
.x_nav_icon {
    display: flex;
    flex-direction: column;
    align-items: center;
    padding-left: 5px;
}

.x_nav_title {
    color: #000000;
    writing-mode: vertical-rl;
    margin: 0.5rem 0;
}
.x_nav_page_toc {
    position: fixed;
    top: 50%;
    left: 60px;
    transform: translateY(-50%);
    padding: 0.5rem;
    background-color: #ffffff;
    box-shadow: 2px 0 4px rgba(0, 0, 0, 0.1);
    z-index: 99;
    width: 250px;
    max-height: 0;
    overflow-y: auto;
    opacity: 0;
    transition: max-height 0.3s ease, opacity 0.3s ease;
    border-radius: 15px;
    display: none;
}

.x_nav_anchor-list {
    list-style-type: none;
    padding-left: 0;
    margin: 0;
    max-height: 450px;
    overflow-y: auto;
}

.x_nav_anchor-list li {
    margin-bottom: 0.3rem;
}

.x_nav_anchor-list a {
    text-decoration: none;
    color: #333333;
    display: block;
    padding: 0.2rem 0;
    transition: color 0.3s ease;
    position: relative;
    padding-left: 15px;
}

.x_nav_anchor-list a::before {
    content: '';
    position: absolute;
    left: 0;
    top: 0;
    bottom: 0;
    width: 2px;
    background-color: #2c9eff;
}

.x_nav_anchor-list a:hover,
.x_nav_anchor-list a:focus {
    color: #007bff;
    text-decoration: none;
}
.toc-h1 {
    font-size: 15px;
    font-weight: normal;
    color: #333;
}

.toc-h2 {
    font-size: 14px;
    font-weight: normal;
    color: #555;
    margin-left: 10px;
}

.toc-h3 {
    font-size: 13px;
    font-weight: normal;
    color: #777;
    margin-left: 20px;
}

.toc-h4 {
    font-size: 12px;
    font-weight: normal;
    color: #999;
    margin-left: 30px;
}

.overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgb(0 0 0 / 0%);
    z-index: 98;
    display: none;
}
</style>




<script>
document.addEventListener('DOMContentLoaded', function () {
    var className = '$x_nav_class'; 
    var selectors = [];
    for (var i = 1; i <= 6; i++) {
        selectors.push(className + ' h' + i);
    }
    var headings = document.querySelectorAll(selectors.join(', '));

    var nav = document.querySelector('.x_nav_nav');
    var tocContainer = document.querySelector('.x_nav_page_toc');
    var anchorList = document.querySelector('.x_nav_anchor-list');
    var overlay = document.querySelector('.overlay');
    var currentHighlight = null;
    if (headings.length === 0) {
        nav.style.display = 'none';
        return;
    }
    headings.forEach(function (heading, index) {
        var level = parseInt(heading.tagName[1]);
        var id = 'toc-' + level + '-' + (index + 1);
        heading.id = id;

        var listItem = document.createElement('li');
        var anchor = document.createElement('a');
        var number = document.createElement('span');

        number.className = `number-${level}`;
        anchor.innerHTML = heading.textContent;
        anchor.insertBefore(number, anchor.firstChild);
        anchor.href = '#' + id;
        listItem.appendChild(anchor);
        if (level === 2) {
            anchor.insertAdjacentHTML('afterbegin', '&nbsp;');
        } else if (level === 3) {
            anchor.insertAdjacentHTML('afterbegin', '&nbsp;&nbsp;');
        } else if (level === 4) {
            anchor.insertAdjacentHTML('afterbegin', '&nbsp;&nbsp;&nbsp;');
        }
        anchor.classList.add('toc-h' + level);

        anchorList.appendChild(listItem);

        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            if (currentHighlight) {
                currentHighlight.classList.remove('highlighted');
            }
            listItem.classList.add('highlighted');
            currentHighlight = listItem;
            document.getElementById(this.getAttribute('href').substring(1)).scrollIntoView({ behavior: 'smooth' });
            hideToc();
        });
    });
    nav.addEventListener('click', function () {
        if (tocContainer.style.display === 'block') {
            hideToc();
        } else {
            showToc();
        }
    });

    function showToc() {
        tocContainer.style.display = 'block';
        tocContainer.style.maxHeight = '500px';
        tocContainer.style.opacity = '1';
        overlay.style.display = 'block';
        nav.style.opacity = '0';
        nav.style.pointerEvents = 'none';
    }

    function hideToc() {
        tocContainer.style.maxHeight = '0';
        tocContainer.style.opacity = '0';
        overlay.style.display = 'none';
        setTimeout(() => {
            tocContainer.style.display = 'none';
            nav.style.opacity = '1';
            nav.style.pointerEvents = 'auto';
        }, 300);
    }
    overlay.addEventListener('click', function () {
        hideToc();
    });
});
</script>

EOT;
}
addAction('log_related', 'x_nav');
