<?php
!defined('EMLOG_ROOT') && exit('access deined!');

// 开启插件时执行该函数
function callback_init() {
    $db = MySql::getInstance();
    $charset = 'utf8mb4';
    $type = 'InnoDB';
    $table = DB_PREFIX . 'yylog_ckplayer';
    $add = "ENGINE=$type DEFAULT CHARSET=$charset;";
    $sql = "
    CREATE TABLE IF NOT EXISTS `$table` (
  `id` int(11) NOT NULL KEY AUTO_INCREMENT COMMENT 'id',
  `gid` int(11) NOT NULL COMMENT '文章id号',
  `videoUrl` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '视频URL',
  `videoWidth` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '视频播放器宽度',
  `videoHeight` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '视频播放器高度',
  `videoType` enum('mp4','m3u8','flv','ts') COLLATE utf8mb4_unicode_ci NOT NULL default 'mp4' COMMENT '视频格式',
  `live` enum('true','false') COLLATE utf8mb4_unicode_ci NOT NULL default 'false' COMMENT '是否直播',
  `autoplay` enum('true','false') COLLATE utf8mb4_unicode_ci NOT NULL default 'true' COMMENT '是否自动播放'
)" . $add;
    $db->query($sql);

}
// 删除插件时执行该函数
function callback_rm() {
    $sql = "DROP TABLE IF EXISTS `" . DB_PREFIX . "yylog_ckplayer`";
    $db = MySql::getInstance();
    $db->query($sql);
}

// 更新插件时执行该函数
function callback_up() {
    $sql = "ALTER TABLE `" . DB_PREFIX . "yylog_ckplayer` 
        ADD `videoType` enum('mp4','m3u8','flv','ts') COLLATE utf8mb4_unicode_ci NOT NULL default 'mp4' COMMENT '视频格式' AFTER `autoplay`,
        ADD `live` enum('true','false') COLLATE utf8mb4_unicode_ci NOT NULL default 'false' COMMENT '是否直播' AFTER `videoType`";
    $db = MySql::getInstance();
    $db->query($sql);
}
