<?php

/**
 * 阅读文章页面
 */
defined('EMLOG_ROOT') || exit('access denied!');
?>

<div class="container container-path">
    <div class="web-path">
        <a class="path" href="<?= BLOG_URL ?>"><i class="icon-simply icon-home mr-5"></i>首页</a><span class="path"><?= simply_sort($sortid, false) ?></span><span class="path">正文</span>
    </div>
</div>
<div class="container frame-container container-article container-log">
    <main class="frame-main">
        <div class="box modularity">
            <div class="modul-info">
                <div class="user-info">
                    <?php
                    $User_Model = new User_Model();
                    $user_info = $User_Model->getOneUser($author);
                    $avatar = BLOG_URL . "admin/views/images/avatar.svg";
                    if ($user_info) {
                        $name = $user_info['nickname'];
                        $avatar = User::getAvatar($user_info['photo']);
                    }
                    ?>
                    <a class="avatar" href="<?= Url::author($author) ?>">
                        <img src="<?= $avatar ?>" alt="<?= $name ?>">
                    </a>
                    <div class="user-meta">
                        <div class="nickname"><a href="<?= Url::author($author) ?>"><?= $name ?></a></div>
                        <div class="other"><?= date('Y-n-j H:i', $date) ?></div>
                    </div>
                </div>
                <ul class="flex-list info">
                    <li class="item read"><i class="icon-simply icon-hourglass mr-5"></i><?= calculate_reading_time($log_content) ?></li>
                    <li class="item view"><i class="icon-simply icon-view mr-5"></i><?= $views ?></li>
                    <li class="item comt"><a href="#comment"><i class="icon-simply icon-message mr-5"></i><?= $comnum ?></a></li>
                </ul>
            </div>
            <div class="modul-body">
                <article>
                    <h1 class="title"><?= topflg($top) ?><?= $log_title ?><?= editflg($logid, $author, '<i class="icon-simply icon-edit ml-5"></i>') ?></h1>
                    <?php if (!empty($excerpt)): ?>
                        <fieldset class="fieldset">
                            <legend class="legend">摘要</legend>
                            <div class="content">
                                <?= $excerpt ?>
                            </div>
                        </fieldset>
                    <?php endif; ?>
                    <div class="content markdown"><?= $log_content ?></div>
                    <?php if (!empty(blog_tag($logid))): ?>
                        <div class="tags">标签：<?= blog_tag($logid) ?></div>
                    <?php endif; ?>
                </article>
                <?php doAction('log_related', $logData) ?>
            </div>
        </div>
        <div class="my-1em log-neighbor">
            <?= neighbor_log($neighborLog) ?>
        </div>
        <div class="box log-comment" id="comment">
            <?= blog_comments_post($logid, $ckname, $ckmail, $ckurl, $verifyCode, $allow_remark) ?>
            <?= blog_comments($comments, $allow_remark) ?>
        </div>
    </main>
    <aside class="frame-aside">
        <?php include View::getView('side'); ?>
    </aside>
</div>
<div class="container">
    <?= widget_link('友情链接') ?>
</div>
<?php include View::getView('footer'); ?>