<?php
/*
Template Name: Simply简洁博客主题
Template Url: https://www.emlog.net/template/detail/1146
Description: Simply是一款简约风格的博客模板，响应式布局、界面简单大方，实用性强。
Version: 1.3.8
Author: emlog
Author Url: https://www.emlog.net/author/index/577
*/

defined('EMLOG_ROOT') || exit('access denied!');
require_once View::getView('functions');
require_once View::getView('module');
if (!function_exists('_g')) {
    emMsg('请开启【模板设置】插件, <a href="/admin/plugin.php">去开启</a>');
}
ob_clean();
$v = '1.3.8';
?>
<!DOCTYPE html>
<html lang="zh-CN">

<head>
    <meta charset="UTF-8">
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="chrome=1,IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <meta name="color-scheme" content="light dark">
    <title><?= $site_title ?></title>
    <meta name="keywords" content="<?= strip_html_tags($site_key) ?>">
    <meta name="description" content="<?= strip_html_tags($site_description) ?>">
    <link rel="alternate" title="RSS" href="<?= BLOG_URL ?>rss.php" type="application/rss+xml">
    <link rel="shortcut icon" href="<?= BLOG_URL ?>favicon.ico">
    <link rel="stylesheet" href="<?= TEMPLATE_URL ?>assets/js/layui/2.9.2/css/layui.css">
    <link rel="stylesheet" href="<?= TEMPLATE_URL ?>assets/js/swiper/8.4.7/swiper-bundle.min.css">
    <link rel="stylesheet" href="<?= TEMPLATE_URL ?>assets/css/reset.css?v=<?= $v ?>">
    <?php if (!empty($logid)): ?>
        <link rel="stylesheet" href="<?= TEMPLATE_URL ?>assets/css/prism.css?t=<?= Option::EMLOG_VERSION_TIMESTAMP ?>">
    <?php endif; ?>
    <link rel="stylesheet" href="<?= TEMPLATE_URL ?>assets/js/icon/iconfont.css?t=<?= Option::EMLOG_VERSION_TIMESTAMP ?>">
    <link rel="stylesheet" href="<?= TEMPLATE_URL ?>assets/css/simply.css?v=<?= $v ?>&t=<?= Option::EMLOG_VERSION_TIMESTAMP ?>">
    <script>
        window.theme = {
            isMobile: /windows phone|iphone|android|HarmonyOS/gi.test(window.navigator.userAgent),
            mediaQuery: window.matchMedia('(prefers-color-scheme: dark)'),
            detectIE: function() {
                let ua = window.navigator.userAgent,
                    ie = ua.indexOf('MSIE ');
                if (ie > 0) {
                    return parseInt(ua.substring(ie + 5, ua.indexOf('.', ie)), 10);
                }
                if (ua.indexOf('Trident/') > 0) {
                    let rv = ua.indexOf('rv:');
                    return parseInt(ua.substring(rv + 3, ua.indexOf('.', rv)), 10);
                }
                let edge = ua.indexOf('.Edge/');
                return edge > 0 && parseInt(ua.substring(edge + 5, ua.indexOf('.', edge)), 10);
            }
        }
        theme.detectIE() && alert('当前站点不支持IE浏览器（或您开启了兼容模式），请使用其他浏览器访问（或关闭兼容模式）。');
        localStorage.getItem('dark-mode') && document.documentElement.classList.add('dark');

        function darkModeHandler() {
            if (!theme.isMobile) return;
            if (theme.mediaQuery.matches) {
                document.documentElement.classList.remove('light');
                document.documentElement.classList.add('dark');
            } else {
                document.documentElement.classList.remove('dark');
                document.documentElement.classList.add('light');
            }
        }

        darkModeHandler();
        theme.mediaQuery.addListener(darkModeHandler);
    </script>
    <?php doAction('index_head') ?>
</head>
<body<?php if (!empty($logid)): ?> class="line-numbers" data-prismjs-copy="复制" data-prismjs-copy-success="已复制" data-prismjs-copy-error="按Ctrl+C复制" <?php endif; ?>>
    <header>
        <div class="flex-v-between container">
            <div class="flex-v-center left">
                <?php if (_g('logotype') == 0): ?>
                    <a class="flex-v-center logo" href="<?= BLOG_URL ?>" title="<?= $bloginfo ?>">
                        <img class="image" src="<?= _g('logoimg'); ?>" alt="<?= $blogname; ?>">
                        <span class="text"><?= $blogname ?></span>
                    </a>
                <?php elseif (_g('logotype') == 1): ?>
                    <a class="flex-v-center logo" href="<?= BLOG_URL ?>" title="<?= $bloginfo ?>">
                        <img class="image" src="<?= _g('logoimg'); ?>" alt="<?= $blogname; ?>">
                    </a>
                <?php else: ?>
                    <a class="flex-v-center logo" href="<?= BLOG_URL ?>" title="<?= $bloginfo ?>">
                        <span class="text"><?= $blogname ?></span>
                    </a>
                <?php endif; ?>
            </div>
            <div class="flex-v-between right">
                <nav>
                    <?= blog_navi() ?>
                    <?php doAction('index_navi_ext') ?>
                </nav>
                <div class="divider-vertical">
                    <button class="button-switch" id="dark-mode" type="button" role="switch">
                        <div class="icon-box">
                            <i class="icon-simply icon-during"></i>
                            <i class="icon-simply icon-night"></i>
                        </div>
                    </button>
                </div>
            </div>
            <div class="flex-center xs-nav-button">
                <div class="nav-burger"></div>
            </div>
            <div class="xs-nav-layer"></div>
        </div>
    </header>