<?php
/*@support tpl_options*/

/**
 * 模板设置的配置文件
 * 详见官网文档-模板开发：https://www.emlog.net/docs/#/template
 */

defined('EMLOG_ROOT') || exit('access denied!');

$options = [
    'TplOptionsNavi'                 => [
        'type'        => 'radio',
        'name'        => '定义设置项标签页名称',
        'values'      => [
            'tpl-global'  => '全局设置（global）',
            'tpl-index'   => '首页设置（index）',
            'tpl-head'    => '头部设置（head）',
            'tpl-foot'    => '尾部设置（foot）',
            'tpl-aside'   => '边栏设置（aside）',
            'tpl-comment' => '评论设置（comment）',
        ],
        'description' => '<h5>关于缩略图</h5><p>Simply模板采用9:16比例缩略图，最佳显示尺寸650px*365px，请将后台“生成缩略图”设置为此尺寸。</p>'
    ],

    // 全局
    'simply_global_thumb'            => [
        'labels'      => 'tpl-global',
        'type'        => 'image',
        'name'        => '■ 文章默认图',
        'values'      => [
            TEMPLATE_URL . 'assets/images/thumb.jpg',
        ],
        'description' => '文章无缩略图时显示此图，最佳尺寸650px*365px'
    ],

    // 首页
    'simply_index_swiper'            => [
        'labels'      => 'tpl-index',
        'type'        => 'text',
        'name'        => '■ 轮播组图',
        'multi'       => 'true',
        'values'      => ['自定义幻灯片1 || ' . BLOG_URL . '?post=1 || ' . TEMPLATE_URL . 'assets/images/650_365_1.jpg
自定义幻灯片2 || ' . BLOG_URL . '?post=2 || ' . TEMPLATE_URL . 'assets/images/650_365_2.jpg
自定义幻灯片3 || ' . BLOG_URL . '?post=3 || ' . TEMPLATE_URL . 'assets/images/650_365_3.jpg'],
        'description' => '尺寸：650px*365px<br>格式：显示标题 || 链接地址 || 图片地址<br>注意：一行一个，中间使用两个竖杠分隔，注意竖杠前后有空格'
    ],
    'simply_index_picture'           => [
        'labels'      => 'tpl-index',
        'type'        => 'text',
        'name'        => '■ 推荐组图',
        'multi'       => 'true',
        'values'      => ['自定义推荐图1 || ' . BLOG_URL . '?post=7 || ' . TEMPLATE_URL . 'assets/images/650_365_7.jpg
自定义推荐图2 || ' . BLOG_URL . '?post=8 || ' . TEMPLATE_URL . 'assets/images/650_365_8.jpg'],
        'description' => '尺寸：650px*365px<br>格式：显示标题 || 链接地址 || 图片地址<br>注意：一行一个，中间使用两个竖杠分隔，注意竖杠前后有空格'
    ],
    'simply_index_adv_text'          => [
        'labels'      => 'tpl-index',
        'type'        => 'text',
        'name'        => '■ 文字广告',
        'multi'       => 'true',
        'values'      => ['文字广告1 || https://simply.webkit.top/?post=1
文字广告2 || https://simply.webkit.top/?post=2'],
        'description' => '位置：推荐组图下方（最新文章上方）<br>格式：广告标题 || 链接地址<br>注意：一行一个，中间使用两个竖杠分隔，注意竖杠前后有空格'
    ],

    // 头部
    'logotype'                       => [
        'labels'  => 'tpl-head',
        'type'    => 'radio',
        'name'    => '■ LOGO显示模式',
        'values'  => [
            '0' => '左图右文',
            '1' => '仅图片',
            '2' => '仅文字',
        ],
        'default' => '1',
    ],
    'logoimg'                        => [
        'labels'      => 'tpl-head',
        'type'        => 'image',
        'name'        => '■ LOGO上传',
        'values'      => [
            TEMPLATE_URL . 'assets/images/logo.png',
        ],
        'description' => '上传LOGO图片。'
    ],

    // 尾部
    'simply_beianMps'                => [
        'labels'      => 'tpl-foot',
        'type'        => 'text',
        'name'        => '■ 公安备案号',
        'values'      => ['京公网安备XXXXXXXXXXXX号'],
        'description' => '请输入公安联网备案号，如：京公网安备XXXXXXXXXXXX号',
    ],

    // 边栏
    'simply_aside_blogger_image'     => [
        'labels'      => 'tpl-aside',
        'type'        => 'image',
        'name'        => '■ 博主背景图',
        'values'      => [
            TEMPLATE_URL . 'assets/images/blogger.jpg',
        ],
        'description' => '边栏博主配图，请为侧边栏添加“个人资料”后查看效果'
    ],
    'simply_aside_blogger_platform'  => [
        'labels'      => 'tpl-aside',
        'type'        => 'text',
        'name'        => '■ 博主链接',
        'multi'       => 'true',
        'values'      => ['<i class="icon-simply icon-github"></i> || #1f2328 || https://github.com/
<i class="icon-simply icon-weibo"></i> || #ea5d5f || https://www.weibo.com/
<i class="icon-simply icon-oschina"></i> || #0b7d3f || https://www.oschina.net/
<i class="icon-simply icon-juejin"></i> || #1e80ff || https://www.juejin.cn/
<i class="icon-simply icon-qq"></i> || #308de9 || https://wpa.qq.com/msgrd?v=3&uin=775118&site=qq&menu=yes'],
        'description' => '格式：链接内容(文本或HTML) || 颜色代码(#开头) || 链接地址<br>注意：一行一个，中间使用两个竖杠分隔，注意竖杠前后有空格'
    ],

    // 评论
    'simply_comment_user_level'      => [
        'labels'  => 'tpl-comment',
        'type'    => 'radio',
        'name'    => '■ 用户等级',
        'values'  => [
            '1' => '显示',
            '0' => '隐藏',
        ],
        'default' => '1',
    ],
    'simply_comment_user_agent'      => [
        'labels'  => 'tpl-comment',
        'type'    => 'radio',
        'name'    => '■ 用户浏览器和操作系统',
        'values'  => [
            '1' => '显示',
            '0' => '隐藏',
        ],
        'default' => '1',
    ],
    'simply_comment_user_geographic' => [
        'labels'  => 'tpl-comment',
        'type'    => 'radio',
        'name'    => '■ 用户地理位置',
        'values'  => [
            '1' => '显示',
            '0' => '隐藏',
        ],
        'default' => '1',
    ],
];
