<?php

/**
 * 自建页面模板
 */
defined('EMLOG_ROOT') || exit('access denied!');
?>

<div class="container container-path">
    <div class="web-path">
        <a class="path" href="<?= BLOG_URL ?>"><i class="icon-simply icon-home mr-5"></i>首页</a><span class="path">页面</span><span class="path"><?= $log_title ?></span>
    </div>
</div>
<div class="container frame-container container-article container-page">
    <main class="frame-main">
        <div class="box modularity">
            <div class="modul-info">
                <div class="user-info">
                    <?php
                    $User_Model = new User_Model();
                    $user_info = $User_Model->getOneUser($author);
                    ?>
                    <a class="avatar" href="<?= Url::author($author) ?>">
                        <img src="<?= $user_info['photo'] ?>" alt="<?= $user_info['nickname'] ?>">
                    </a>
                    <div class="user-meta">
                        <div class="nickname"><a href="<?= Url::author($author) ?>"><?= $user_info['nickname'] ?></a></div>
                        <div class="other"><?= date('Y-n-j H:i', $date) ?></div>
                    </div>
                </div>
                <ul class="flex-list info">
                    <li class="item read"><i class="icon-simply icon-hourglass mr-5"></i><?= calculate_reading_time($log_content) ?></li>
                    <li class="item view"><i class="icon-simply icon-view mr-5"></i><?= $views ?></li>
                    <li class="item comt"><a href="#comment"><i class="icon-simply icon-message mr-5"></i><?= $comnum ?></a></li>
                </ul>
            </div>
            <div class="modul-body">
                <article>
                    <h1 class="title"><?= $log_title ?></h1>
                    <div class="feed">温馨提示：本文最后更新于<span><?= date('Y年n月j日 H:i', $date) ?></span>，若内容或图片失效，请在下方<a href="#comment">留言</a>或联系博主。</div>
                    <div class="content"><?= $log_content ?></div>
                </article>
                <ul class="log-copyright">
                    <li class="item">本文作者：<?= blog_author($author, false, false) ?></li>
                    <li class="item">本文链接：<?= Url::log($logid) ?><i class="clipboard icon-simply icon-copy-fill ml-5" data-clipboard-text="<?= Url::log($logid) ?>"></i></li>
                    <li class="item">版权申明：除非特别说明，否则均为本站原创文章，转载或复制请注明出处。</li>
                </ul>
            </div>
        </div>
        <div class="box log-comment" id="comment">
            <?= blog_comments_post($logid, $ckname, $ckmail, $ckurl, $verifyCode, $allow_remark) ?>
            <?= blog_comments($comments, $allow_remark) ?>
        </div>
    </main>
    <aside class="frame-aside">
        <?php include View::getView('side'); ?>
    </aside>
</div>
<div class="container">
    <?= widget_link('友情链接') ?>
</div>
<?php include View::getView('footer'); ?>