<?php

/**
 * 首页推荐模板
 */
defined('EMLOG_ROOT') || exit('access denied!');
$data_swipers = studio_string_to_array('simply_index_swiper', 0, 5);
$data_recommends = studio_string_to_array('simply_index_picture', 0, 2);
?>

<div class="display-flex film-box">
    <?php if (!empty($data_swipers)): ?>
        <div class="swiper swiper-filmstrip" id="swiper-filmstrip-index-1">
            <div class="swiper-wrapper">
                <?php foreach ($data_swipers as $item): ?>
                    <div class="swiper-slide">
                        <a class="percent-image" href="<?= trim($item[1]) ?>">
                            <figure class="figure">
                                <img src="<?= trim($item[2]) ?>" alt="<?= trim($item[0]) ?>" />
                                <figcaption class="figcaption">
                                    <span class="badge mr-5">推荐</span>
                                    <span class="title"><?= trim($item[0]) ?></span>
                                </figcaption>
                            </figure>
                        </a>
                    </div>
                <?php endforeach; ?>
            </div>
            <div class="simply-pagination"></div>
            <div class="simply-button-prev">
                <i class="icon-simply icon-prev"></i>
            </div>
            <div class="simply-button-next">
                <i class="icon-simply icon-next"></i>
            </div>
        </div>
    <?php
    endif;
    if (!empty($data_recommends)):
    ?>
        <ul class="recommend-image">
            <?php foreach ($data_recommends as $item): ?>
                <li class="item">
                    <a class="percent-image" href="<?= trim($item[1]) ?>">
                        <figure class="figure">
                            <img src="<?= trim($item[2]) ?>" alt="<?= trim($item[0]) ?>" />
                            <figcaption class="figcaption">
                                <span class="badge mr-5">推荐</span>
                                <span class="title"><?= trim($item[0]) ?></span>
                            </figcaption>
                        </figure>
                    </a>
                </li>
            <?php endforeach; ?>
        </ul>
    <?php endif; ?>
</div>